// StreamCatcherDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sc580.h"
#include "sc580Dlg.h"
#include "VideoQualityDlg.h"
#include "VideoInputDlg.h"
#include "AduioInputDlg.h"
#include "FileRecordDialog.h"
#include "ShareRecordDialog.h"

#define COMPILE_MULTIMON_STUBS

#include <MULTIMON.H>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID Dbg( CHAR* pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SC] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 5, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
}

// INITIALIZE STATIC CLASS VARIABLE 
//
sc580Dlg*	sc580Dlg::s_psc500Dlg = 0;

CRect		sc580Dlg::s_rect_slipts_display[ 8 ] = { 0 };

CRect		sc580Dlg::s_rect_slipts_display_clone[ 8 ] = { 0 };

//  FORMAT CHANGED CALLBACK FUNCTION
//
QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
	Dbg("format changed Detected  \n");

	sc580Dlg* m_pMainDialog = sc580Dlg::s_psc500Dlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDialog->m_nVideoWidth[ nChannelNum ] = nVideoWidth;

	m_pMainDialog->m_nVideoHeight[ nChannelNum ] = nVideoHeight;

	m_pMainDialog->m_dVideoFrameRate[ nChannelNum ] = dVideoFrameRate;

	// OUTPUT FORMAT CHANGED MESSAGE
	//
	CHAR strVideoInput[ MAX_PATH ] = { 0 };

	CHAR strAudioInput[ MAX_PATH ] = { 0 };

	CHAR strFrameType[ MAX_PATH ] = { 0 }; 

    UINT nVH = 0;
            
    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }
 	
	if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }
	
	if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}
	
	if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}
	
	if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}
	
    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}
	
	if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}
	
	if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }
	
	m_pMainDialog->m_strFormatChangedOutput[ nChannelNum ].Format( "INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s",

													nVideoWidth,

													nVH,

													strFrameType,

													dVideoFrameRate,

													nAudioChannels,

													nAudioBitsPerSample,

													nAudioSampleFrequency,

													strVideoInput,

													strAudioInput );



    // NO SOURCE
    //
    if ( nVideoWidth == 0 && 
		
		 nVideoHeight == 0 &&

		 dVideoFrameRate == 0.0 &&

		 nAudioChannels == 0 &&

		 nAudioBitsPerSample == 0 &&

		 nAudioSampleFrequency == 0 ) {

		m_pMainDialog->m_bNoSignal[ nChannelNum ] = TRUE;		
	}
    else {

		m_pMainDialog->m_bNoSignal[ nChannelNum ] = FALSE;		
    }

    return QCAP_RT_OK;
}    

// NO SIGNAL DETEACTED CALLBACK FUNCTION
//
QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	sc580Dlg* m_pMainDialog = sc580Dlg::s_psc500Dlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	Dbg("No Signal Detected  \n");

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	m_pMainDialog->m_bNoSignal[ nChannelNum ] = TRUE;

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDialog->m_nVideoWidth[ nChannelNum ] = 0;

	m_pMainDialog->m_nVideoHeight[ nChannelNum ] = 0;

	return QCAP_RT_OK;
}

// SIGNAL REMOVED CALLBACK FUNCTION
//
QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	sc580Dlg* m_pMainDialog = sc580Dlg::s_psc500Dlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	Dbg(" Signal Removed \n");

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	m_pMainDialog->m_bNoSignal[ nChannelNum ] = TRUE;

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDialog->m_nVideoWidth[ nChannelNum ] = 0;

	m_pMainDialog->m_nVideoHeight[ nChannelNum ] = 0;

    return QCAP_RT_OK;
}    

// PREVIEW VIDEO CALLBACK FUNCTION
//
QRETURN on_process_preview_video_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	sc580Dlg* m_pMainDialog = sc580Dlg::s_psc500Dlg;

	ULONG nChannelNum = (ULONG)pUserData;

	if ( m_pMainDialog->m_bIsShareRecord && m_pMainDialog->m_bShareRecordCH[ nChannelNum ] ) {
		
		QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, MAKEFOURCC('Y', 'V', '1', '2'), m_pMainDialog->m_nVideoWidth[ nChannelNum ], m_pMainDialog->m_nVideoHeight[ nChannelNum ], pFrameBuffer, nFrameBufferLen );
	}

    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	sc580Dlg* m_pMainDialog = sc580Dlg::s_psc500Dlg;

	ULONG nChannelNum = (ULONG)pUserData;

	if (m_pMainDialog->m_bIsShareRecord && m_pMainDialog->m_bShareRecordCH[ nChannelNum ] ) {

		QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
	}

	return QCAP_RT_OK;
}

/////////////////////////////////////////////////////////////////////////////
// sc580Dlg dialog

sc580Dlg::sc580Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(sc580Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(sc580Dlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void sc580Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(sc580Dlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(sc580Dlg, CDialog)
	//{{AFX_MSG_MAP(sc580Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// sc580Dlg message handlers

void sc580Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
	// CDialog::OnOK();
}

void sc580Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	// CDialog::OnCancel();
}

BOOL sc580Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	sc580Dlg::s_psc500Dlg = this;

	// INITIALIZE MEMBER VARIABLES
	//
	{	m_bVideoDeinterlaceEnable = FALSE;

		m_bShareSupportGPU1_1 = FALSE;

		m_bIsShareRecord = FALSE;
		
		m_bSupportGPU1 = FALSE;
	
		m_bIsRecord1 = FALSE;

		m_bSupportGPU2 = FALSE;
	
		m_bIsRecord2 = FALSE;

		m_bSupportGPU3 = FALSE;
	
		m_bIsRecord3 = FALSE;

		m_bSupportGPU4 = FALSE;
	
		m_bIsRecord4 = FALSE;

		m_bSupportGPU5 = FALSE;
	
		m_bIsRecord5 = FALSE;

		m_bSupportGPU6 = FALSE;
	
		m_bIsRecord6 = FALSE;

		m_bSupportGPU7 = FALSE;
	
		m_bIsRecord7 = FALSE;

		m_bSupportGPU8 = FALSE;
	
		m_bIsRecord8 = FALSE;

		m_nCurSelectChannelNumber = -1;

		m_nAudioPlayChannel = -1;

		m_nWndState = 0x00000000;		// 0 = SPLIT, 1 = FULL SCREEN

		m_bEnableSub = TRUE;

		for ( ULONG i =0; i < 8; i++ ) {
		
			m_hVideoDevice[ i ] = 0;

			m_hCloneCapDev[ i ] = 0;

			m_nVideoWidth[ i ] = 0;

			m_nVideoHeight[ i ] = 0;

			m_bVideoIsInterleaved[ i ] = FALSE;

			m_dVideoFrameRate[ i ] = 0.0;			

			m_nAudioChannels[ i ] = 0;

			m_nAudioBitsPerSample[ i ] = 0;

			m_nAudioSampleFrequency[ i ] = 0;
			
			m_bNoSignal[ i ] = TRUE;

			m_nSharpness[ i ] = 128;

			m_nSaturation[ i ] = 128;

			m_nHue[ i ] = 128;

			m_nConstrast[ i ] = 128;

			m_nBrightness[ i ] = 128;
			
			m_bShareRecordCH[ i ] = FALSE;
		} 

		// GET DEFAULT RECORD PATH
		// 
		{	BYTE pData[ MAX_PATH ]; DWORD dwType = REG_SZ; DWORD dwData = MAX_PATH;

			HKEY hKey = NULL; RegOpenKey( HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", &hKey );

			RegQueryValueEx( hKey, "Personal", NULL, &dwType, pData, &dwData );

			RegCloseKey( hKey );

			CHAR psz[ MAX_PATH ] = "";

			if ( strlen( (CHAR*)(pData) ) ) {

				m_strDefaultPath.Format( "%s", (CHAR*)(pData) );
			}
			else {

				m_strDefaultPath.Format( "%s", "" );
			}

			m_strSnapshotPath.Format( "%s\\My Snapshots", m_strDefaultPath );

			m_strRecordPath.Format( "%s\\My Records", m_strDefaultPath );

			CreateDirectory( m_strSnapshotPath, NULL );

			CreateDirectory( m_strRecordPath, NULL );
		}

		m_strRecordFileName = "";
	}
	// INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// INITIALIZE USER INTERFACE RESOURCE
	//
	{	// INITIALIZE MAIN WINDOW
		//
		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		MoveWindow( 0, 0, cx + DEFAULT_NORMAL_WIDTH, cy + DEFAULT_NORMAL_HEIGHT );						// CREATE AND MAINTIN LAYOUT

		SetWindowPos( &CWnd::wndTop, 0, 0, 0, 0, SWP_NOSIZE );		// SET THE LOCATION OF MAIN DIALOG
		
		CHAR szStr[ MAX_PATH ] = { 0 };

		for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ )	{			

			sc580Dlg::s_rect_slipts_display[ i ] = GetSplitWndPos_sc500Dlg(	i, DEFAULT_GRID_DIVISIONS, cx + 1280, cy + 540 );

			sc580Dlg::s_rect_slipts_display_clone[ i ] = CRect( sc580Dlg::s_rect_slipts_display[ i ].right - 180, sc580Dlg::s_rect_slipts_display[ i ].bottom - 120, sc580Dlg::s_rect_slipts_display[ i ].right, sc580Dlg::s_rect_slipts_display[ i ].bottom );

			sprintf( szStr, "MyChannelWindowLIVE#%02d", i + 1 );

			m_oChannelWindows_LIVE[ i ].Create(	NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, sc580Dlg::s_rect_slipts_display[ i ], this, i + 0x00000001, NULL );		// VIDEO WINDOW
			
			sprintf( szStr, "MyChannelWindowBK#%02d", i + 1 );

			m_oChannelWindows_BK[ i ].Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, sc580Dlg::s_rect_slipts_display[ i ], this, i + 0x10000001, NULL );		// BACKGROUND WINDOW

			sprintf( szStr, "MyChannelWindowCLONE#%02d", i + 1 );

			m_oCloneWindows[ i ].Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect( 0, 0, 0, 0 ), this, i + 0x20000001, NULL );			// CLONE WINDOW
			
			m_oCloneWindows[ i ].MoveWindow( sc580Dlg::s_rect_slipts_display_clone[ i ] );

			m_oChannelWindows_LIVE[ i ].ShowWindow( TRUE );

			m_oChannelWindows_BK[ i ].ShowWindow( FALSE );

			m_oCloneWindows[ i ].ShowWindow( FALSE );
		}

		// INITIALIZE SETUP DIALOG
		//
		{	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );			

			MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 
			
			GetMonitorInfo( hMonitor, &sMonitorInfo );

			CRect oMonitorRect = sMonitorInfo.rcWork;			
			
			m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

			CRect oWindowRect; m_oSetupDialog.GetWindowRect( &oWindowRect );

			CRect oClientRect; m_oSetupDialog.GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), (oMonitorRect.Width() - (960 + cx)) / 2,

														  (oMonitorRect.Height() - (450 + cy)),
														  
														  (cx + 960), 

														  (cy + 420),
														  
														  (NULL));
			m_oSetupDialog.ShowWindow( TRUE );
		}

		SetWindowText( "" DEFAULT_PRODUCT ", " DEFAULT_PRODUCT_VERSION );	
	}

	HwInitialize();	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// CALCULATE EACH WINDOW LOCATION
//
CRect sc580Dlg::GetSplitWndPos_sc500Dlg( ULONG nChannelNumber, ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight )
{
	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG nSplitsWidth = nRendererWidth / ( nGridDivisions * 2 );  //480
			
	ULONG nSplitsHeight = nRendererHeight / nGridDivisions ; //270

	ULONG nMaxChannel = nGridDivisions * nGridDivisions * 2;  //8

	ULONG x = nChannelNumber / ( nGridDivisions * 2 );

	ULONG y = nChannelNumber % ( nGridDivisions * 2 );

	ULONG top = nSplitsWidth * y;
				
	ULONG left = nSplitsHeight * x;

	ULONG bottom = top + nSplitsWidth;

	ULONG right = left + nSplitsHeight;
			
	return CRect( top, left, bottom, right );
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void sc580Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR sc580Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL sc580Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	CRect rect_client;	GetClientRect( &rect_client );

	CBrush brush_fill_rect( RGB(0, 0, 0) );

	pDC->FillRect( &rect_client, &brush_fill_rect );

	return CWnd::OnEraseBkgnd(pDC);
}

BOOL sc580Dlg::OnLButtonDblClk_ChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point ) 
{
	// TODO: Add your message handler code here and/or call default

	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );	

	MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 

	GetMonitorInfo( hMonitor, &sMonitorInfo );

	CRect oMonitorRect = sMonitorInfo.rcMonitor;

	m_nCurSelectChannelNumber = nChannelNum;

	CHAR szStr[ MAX_PATH ] = { 0 };	
		
	if ( m_nWndState ) {		// FULL TO SPLIT SCREEN

		//m_nCurSelectChannelNumber = -1;

		m_oSetupDialog.m_btnVideoInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );
			
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( FALSE ); 

		for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) {

			if ( m_oSetupDialog.m_btnShowCloneVideo.GetCheck() == TRUE ) { m_oCloneWindows[ i ].ShowWindow( TRUE ); }
			
			else { m_oCloneWindows[ i ].ShowWindow( FALSE ); }

			
			if ( i == nChannelNum ) {

				m_oChannelWindows_LIVE[ i ].MoveWindow( sc580Dlg::s_rect_slipts_display[ i ] );

				m_oChannelWindows_BK[ i ].MoveWindow( sc580Dlg::s_rect_slipts_display[ i ] );

				m_oCloneWindows[ i ].MoveWindow( sc580Dlg::s_rect_slipts_display_clone[ i ] );

				QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

				m_nAudioPlayChannel = -1;
				
				//m_nCurSelectChannelNumber = -1;
			}
			else {

				m_oChannelWindows_LIVE[ i ].ShowWindow( TRUE );

				m_oChannelWindows_BK[ i ].ShowWindow( FALSE );
			}
		}			
			
		m_nWndState = 0;
	}		
	else {		//  SPLIT TO FULL SCREEN
			
		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		CRect rect( 0, 0 ,  cx + DEFAULT_NORMAL_WIDTH, cy + DEFAULT_NORMAL_HEIGHT );			

		//m_nCurSelectChannelNumber = nChannelNum;

		m_oSetupDialog.m_btnVideoInput.EnableWindow( TRUE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( TRUE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( TRUE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( TRUE );
			
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( TRUE ); 		

		for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) {

			if ( i ==  nChannelNum ) {

				m_oChannelWindows_LIVE[ i ].MoveWindow( rect );
					
				m_oChannelWindows_BK[ i ].MoveWindow( rect );

				m_oCloneWindows[ i ].MoveWindow( DEFAULT_NORMAL_WIDTH - 352, DEFAULT_NORMAL_HEIGHT - 288,  352, 288);	

				QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 100 );
					
				m_nAudioPlayChannel = i;
				
			}
			else {

				m_oChannelWindows_LIVE[ i ].ShowWindow( FALSE );

				m_oChannelWindows_BK[ i ].ShowWindow( FALSE );

				m_oCloneWindows[ i ].ShowWindow( FALSE );

			}
		}

		m_nWndState = 1;
	} 

	return TRUE;
}

BOOL sc580Dlg::OnButtonVideoInput_SetupDialog() 
{	
	// TODO: Add your control notification handler code here

	ULONG nChannelNum = m_nCurSelectChannelNumber;

	if ( m_hVideoDevice[ nChannelNum ] == 0 ) { return FALSE; }

	CVideoInputDlg dlg;

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL sc580Dlg::OnButtonAudioInput_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	ULONG nChannelNum = m_nCurSelectChannelNumber;

	if ( m_hVideoDevice[ nChannelNum ] == 0 ) { return FALSE; }

	CAduioInputDlg dlg(this);

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL sc580Dlg::OnButtonVideoQuality_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	ULONG nChannelNum = m_nCurSelectChannelNumber;
	
	if ( m_hVideoDevice[ nChannelNum ] == 0 ) { return FALSE; }

	CVideoQualityDlg dlg(this);

	INT_PTR nResponse = -1;

	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL sc580Dlg::OnCheckAutoDeinterlace_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	if ( m_oSetupDialog.m_checkAutoDeinterlace.GetCheck() == TRUE ) {

		m_bVideoDeinterlaceEnable = TRUE;
	}
	else {

		m_bVideoDeinterlaceEnable = FALSE;
	}

	for ( ULONG i = 0; i < 8; i++ ) {

		if ( m_hVideoDevice[ i ] != 0 ) {

			if ( m_bVideoDeinterlaceEnable ) {

				QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 1 );
			}		
			else {

				QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 0 );
			}        
		}
	}

	return TRUE;
}

BOOL sc580Dlg::OnCheckShowCloneVideo_SetupDialog()
{
	if ( m_oSetupDialog.m_btnShowCloneVideo.GetCheck() == TRUE ) {

		for ( ULONG i = 0; i < 8; i++ ) {

			m_oChannelWindows_LIVE[ i ].SetParent( CWnd::GetDesktopWindow() );

			m_oChannelWindows_BK[ i ].SetParent( CWnd::GetDesktopWindow() );

			m_oCloneWindows[ i ].SetParent( CWnd::GetDesktopWindow() );

			m_oChannelWindows_LIVE[ i ].SetParent( this );

			m_oChannelWindows_BK[ i ].SetParent( this );

			m_oCloneWindows[ i ].SetParent( this );
			
			if ( !m_nWndState ) {		// FULL TO SPLIT SCREEN
		
				m_oCloneWindows[ i ].ShowWindow( TRUE );
			}
			else {
				
				if ( i == m_nCurSelectChannelNumber ) { m_oCloneWindows[ i ].ShowWindow( TRUE ); }
			}			

			if ( m_hVideoDevice[ i ] != 0 ) {
				
				QCAP_CREATE_CLONE( m_hVideoDevice[ i ], m_oCloneWindows[ i ].GetSafeHwnd(), &m_hCloneCapDev[ i ] );

				if ( m_hCloneCapDev[ i ] != 0 ) {

					QCAP_RUN( m_hCloneCapDev[ i ] );

					QCAP_SET_AUDIO_VOLUME( m_hCloneCapDev[ i ], 0 );
				}
			}		
		}
	}
	else {

		for ( ULONG i = 0; i < 8; i++ ) {
		
			m_oCloneWindows[ i ].ShowWindow( FALSE );

			if ( m_hCloneCapDev[ i ] != 0 ) {

				QCAP_STOP( m_hCloneCapDev[ i ] );

				QCAP_DESTROY( m_hCloneCapDev[ i ] );

				m_hCloneCapDev[ i ] = 0;
			}
		}
	}    

	return TRUE;
}

BOOL sc580Dlg::OnButtonSnapshotJPG_SetupDialog() 
{
	ULONG nChannelNum = m_nCurSelectChannelNumber;

	if ( m_hVideoDevice[ nChannelNum ] != 0 ) {

		CString strFullPathName;
		
		strFullPathName.Format( _T("%s\\unname%d.jpg"), m_strSnapshotPath, nChannelNum );

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_JPG( m_hVideoDevice[ nChannelNum ], psz, 100 );

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonSnapshotBMP_SetupDialog() 
{
	ULONG nChannelNum = m_nCurSelectChannelNumber;

	if ( m_hVideoDevice[ nChannelNum ] != 0 ) {
		
		CString strFullPathName;

		strFullPathName.Format( _T("%s\\unname%d.bmp"), m_strSnapshotPath, nChannelNum );
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_BMP( m_hVideoDevice[ nChannelNum ], psz );

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL sc580Dlg::OnCheckD1_SetupDialog() 
{
	if( m_hVideoDevice[ 0 ] != 0 )
	{
		for( ULONG i = 0; i < 8; i++ )
		{
			QCAP_STOP( m_hVideoDevice[ i ] );

			QCAP_DESTROY(m_hVideoDevice[ i ]);
		}

		for( ULONG i = 0; i < 8; i++ )
		{
			QCAP_CREATE( "MZ0380 PCI", i, m_oChannelWindows_LIVE[ i ].m_hWnd, &m_hVideoDevice[ i ] ,1);

			if(m_oSetupDialog.m_btnSubStream.GetCheck() == TRUE)
			{
				for(ULONG i = 0; i < 8; i++ )
				{
					if(m_hVideoDevice[ i ] != NULL)
					{
						QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ i ], 273, 1);
					}
				}

				m_bEnableSub = TRUE;
			}
			else
			{
				for(ULONG i = 0; i < 8; i++ )
				{
					if(m_hVideoDevice[ i ] != NULL)
					{
						QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ i ], 273, 0);
					}
				}

				m_bEnableSub = FALSE;
			}

			if(i == 0) { QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ 0 ], 214, 0); }

			if ( m_hVideoDevice[ i ] == 0 ) { continue; }

			QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], on_process_format_changed, (PVOID)i );

			QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_process_preview_video_buffer, (PVOID)i );

			QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_process_preview_audio_buffer, (PVOID)i );

			QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], on_process_no_signal_detected, (PVOID)i );

			QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], on_process_signal_removed, (PVOID)i );

			QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 0 );

			QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

			QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_hVideoDevice[ i ], 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF, 0, 0);

			if(m_bEnableSub== true)
			{
				QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_hVideoDevice[ i ], 1, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 1 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2, 0, 0);
			}

			QCAP_SET_VIDEO_STANDARD(m_hVideoDevice[ i ], QCAP_STANDARD_TYPE_NTSC_M);

			QCAP_RUN( m_hVideoDevice[ i ] );
		}
	}
	
	return TRUE;
}

BOOL sc580Dlg::OnCheckNOTD1_SetupDialog() 
{
	if(  m_hVideoDevice[ 0 ] != 0 )
	{
		for( ULONG i = 0; i < 8; i++ )
		{
			QCAP_STOP( m_hVideoDevice[ i ] );

			QCAP_DESTROY(m_hVideoDevice[ i ]);
		}

		for( ULONG i = 0; i < 8; i++ )
		{
			QCAP_CREATE( "MZ0380 PCI", i, m_oChannelWindows_LIVE[ i ].m_hWnd, &m_hVideoDevice[ i ] ,1);

			if(m_oSetupDialog.m_btnSubStream.GetCheck() == TRUE)
			{
				for(ULONG i = 0; i < 8; i++ )
				{
					if(m_hVideoDevice[ i ] != NULL)
					{
						QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ i ], 273, 1);
					}
				}

				m_bEnableSub = TRUE;
			}
			else
			{
				for(ULONG i = 0; i < 8; i++ )
				{
					if(m_hVideoDevice[ i ] != NULL)
					{
						QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ i ], 273, 0);
					}
				}

				m_bEnableSub = FALSE;
			}

			if(i == 0) { QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ 0 ], 214, 1); }

			if ( m_hVideoDevice[ i ] == 0 ) { continue; }

			QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], on_process_format_changed, (PVOID)i );

			QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_process_preview_video_buffer, (PVOID)i );

			QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_process_preview_audio_buffer, (PVOID)i );

			QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], on_process_no_signal_detected, (PVOID)i );

			QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], on_process_signal_removed, (PVOID)i );

			QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 0 );

			QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

			QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_hVideoDevice[ i ], 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF, 0, 0);

			if(m_bEnableSub== true)
			{
				QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_hVideoDevice[ i ], 1, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 1 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2, 0, 0);
			}

			QCAP_SET_VIDEO_STANDARD(m_hVideoDevice[ i ], QCAP_STANDARD_TYPE_NTSC_M);

			QCAP_RUN( m_hVideoDevice[ i ] );
		}
	}
	
	return TRUE;
}

BOOL sc580Dlg::OnButtonEnableSubStream_SetupDialog() 
{
	if(m_oSetupDialog.m_btnSubStream.GetCheck() == TRUE)
	{
		for(ULONG i = 0; i < 8; i++ )
		{
			if(m_hVideoDevice[ i ] != NULL)
			{
				QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ i ], 273, 1);
			}
		}

		m_bEnableSub = TRUE;
	}
	else
	{
		for(ULONG i = 0; i < 8; i++ )
		{
			if(m_hVideoDevice[ i ] != NULL)
			{
				QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ i ], 273, 0);
			}
		}

		m_bEnableSub = FALSE;
	}

	return TRUE;
}

void sc580Dlg::OnDestroy() 
{
	KillTimer( 0x00000001 );

	// UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUninitialize();
	}
	// UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	for(ULONG i = 0; i < 8 ; i++ )
		{
			m_oChannelWindows_LIVE[ i ].DestroyWindow();

			m_oChannelWindows_BK[ i ].DestroyWindow();
		}

		m_oSetupDialog.DestroyWindow();
	}
	// UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}
}

BOOL sc580Dlg::HwInitialize()
{
	// CALLBACK FUNCTION
	//        
	PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB[ 8 ] = { 0 };

	PF_VIDEO_PREVIEW_CALLBACK  m_pPreviewVideoCB[ 8 ] = { 0 };

	PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB[ 8 ] = { 0 };
   
	PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB[ 8 ] = { 0 };

	PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB[ 8 ] = { 0 };

	BOOL bIsDeviceRun = FALSE;

	for ( ULONG i = 0; i < 8; i++ ) {

		// CREATE CAPTURE DEVICE
		//
		QCAP_CREATE( "MZ0380 PCI", i, m_oChannelWindows_LIVE[ i ].m_hWnd, &m_hVideoDevice[ i ] ,1);

		if ( m_hVideoDevice[ i ] == 0 ) { continue; }

		bIsDeviceRun = TRUE;

		//DISABLE SUB
		QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_hVideoDevice[ i ], 273, 0);

		// REGISTER FORMAT CHANGED CALLBACK FUNCTION
		// 
		m_pFormatChangedCB[ i ] = on_process_format_changed;

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], m_pFormatChangedCB[ i ], (PVOID)i );

		// REGISTER PREVIEW VIDEO CALLBACK FUNCTION
		// 
		m_pPreviewVideoCB[ i ] = on_process_preview_video_buffer;

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewVideoCB[ i ], (PVOID)i );

		// REGISTER PREVIEW AUDIO CALLBACK FUNCTION
		//
		m_pPreviewAudioCB[ i ] = on_process_preview_audio_buffer;

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewAudioCB[ i ], (PVOID)i );
		
		// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
		//
		m_pNoSignalDetectedCB[ i ] = on_process_no_signal_detected;

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], m_pNoSignalDetectedCB[ i ], (PVOID)i );

		// REGISTER SIGNAL REMOVED CALLBACK FUNCTION
		//
		m_pSignalRemovedCB[ i ] =  on_process_signal_removed;

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], m_pSignalRemovedCB[ i ], (PVOID)i );

		QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 0 );

		QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

		QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_hVideoDevice[ i ], 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF, 0, 0);

		//QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_hVideoDevice[ i ], 1, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 1 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2, 0, 0);

		QCAP_SET_VIDEO_STANDARD(m_hVideoDevice[ i ], QCAP_STANDARD_TYPE_NTSC_M);

		QCAP_RUN( m_hVideoDevice[ i ] );
	}
  
	SetTimer( 0x00000001, 1000, NULL );

	SetTimer( 0x00000002, 1000, NULL );

	// UPDATE USER INTERFACE RESOURCE
	//
	if ( bIsDeviceRun ) { 

		m_oSetupDialog.m_btnVideoInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );
				
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( FALSE);

		m_oSetupDialog.m_btnShowCloneVideo.EnableWindow( TRUE );

		m_oSetupDialog.m_checkAutoDeinterlace.EnableWindow( TRUE ); 

		m_oSetupDialog.m_checkAutoDeinterlace.SetCheck( 0 );

		m_oSetupDialog.m_btnSubStream.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnSubStream.SetCheck( 0 );
	}
	else {

		m_oSetupDialog.m_btnVideoInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );
			
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnShowCloneVideo.EnableWindow( TRUE );

		m_oSetupDialog.m_checkAutoDeinterlace.EnableWindow( TRUE ); 

		m_oSetupDialog.m_checkAutoDeinterlace.SetCheck( 0 );

		m_oSetupDialog.m_btnSubStream.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnSubStream.SetCheck( 0 );
	}	

	return TRUE;
}

BOOL sc580Dlg::HwUninitialize()
{	
	for ( ULONG i = 0; i < 8; i++ ) {

		if ( m_hCloneCapDev[ i ] != 0 ) {

			QCAP_STOP( m_hCloneCapDev[ i ] );

			QCAP_DESTROY( m_hCloneCapDev[ i ] );

			m_hCloneCapDev[ i ] = NULL;
		}
		
		if ( m_hVideoDevice[ i ] != 0 ) {

			QCAP_STOP( m_hVideoDevice[ i ] );

			QCAP_DESTROY( m_hVideoDevice[ i ] );

			m_hVideoDevice[ i ] = NULL;
		}
	}

	return TRUE;
}

void sc580Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if ( nIDEvent == 0x00000001 ) {	
		
		for ( ULONG i = 0; i < 8; i++ ) {
			
			if ( m_hVideoDevice[ i ] == NULL ) { continue ; }

			else {

				if ( i == 0 ) {

					if ( m_bIsRecord1 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord1 = false;
					}
				}

				if ( i == 1 ) {

					if ( m_bIsRecord2 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord2 = false;
					}
				}

				if ( i == 2 ) {

					if ( m_bIsRecord3 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord3 = false;
					}
				}

				if ( i == 3 ) {

					if ( m_bIsRecord4 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord4 = false;
					}
				}
				if ( i == 4 ) {

					if ( m_bIsRecord5 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord5 = false;
					}
				}
				if ( i == 5 ) {

					if ( m_bIsRecord6 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord6 = false;
					}
				}
				if ( i == 6 ) {

					if ( m_bIsRecord7 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord7 = false;
					}
				}
				if ( i == 7 ) {

					if ( m_bIsRecord8 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord8 = false;
					}
				}
			}
		}
	}

	// TO CONTROL WHETHER THE SIGNAL OF EACH CHNNAEL IS OR ISN'T
	//
	if( nIDEvent == 0x00000002 ) {

		if ( !m_nWndState ) { 

			for ( ULONG i = 0; i < 8; i++ ) {			

				if ( m_bNoSignal[ i ] ) {				

					if ( i == 0 ) { m_oSetupDialog.m_editDeviceFormatInformation_1.SetWindowText( _T("CH1_INFO :...") ); }

					if ( i == 1 ) { m_oSetupDialog.m_editDeviceFormatInformation_2.SetWindowText( _T("CH2_INFO :...") ); }

					if ( i == 2 ) { m_oSetupDialog.m_editDeviceFormatInformation_3.SetWindowText( _T("CH3_INFO :...") ); }

					if ( i == 3 ) { m_oSetupDialog.m_editDeviceFormatInformation_4.SetWindowText( _T("CH4_INFO :...") ); }

					if ( i == 4 ) { m_oSetupDialog.m_editDeviceFormatInformation_5.SetWindowText( _T("CH5_INFO :...") ); }

					if ( i == 5 ) { m_oSetupDialog.m_editDeviceFormatInformation_6.SetWindowText( _T("CH6_INFO :...") ); }

					if ( i == 6 ) { m_oSetupDialog.m_editDeviceFormatInformation_7.SetWindowText( _T("CH7_INFO :...") ); }

					if ( i == 7 ) { m_oSetupDialog.m_editDeviceFormatInformation_8.SetWindowText( _T("CH8_INFO :...") ); }

					m_oChannelWindows_LIVE[ i ].ShowWindow( FALSE );

					m_oChannelWindows_BK[ i ].ShowWindow( TRUE );
				}
				else {

					if ( i == 0 ) { m_oSetupDialog.m_editDeviceFormatInformation_1.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 0 ] ); }

					if ( i == 1 ) { m_oSetupDialog.m_editDeviceFormatInformation_2.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 1 ] ); }

					if ( i == 2 ) { m_oSetupDialog.m_editDeviceFormatInformation_3.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 2 ] ); }

					if ( i == 3 ) { m_oSetupDialog.m_editDeviceFormatInformation_4.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 3 ] ); }

					if ( i == 4 ) { m_oSetupDialog.m_editDeviceFormatInformation_5.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 4 ] ); }

					if ( i == 5 ) { m_oSetupDialog.m_editDeviceFormatInformation_6.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 5 ] ); }

					if ( i == 6 ) { m_oSetupDialog.m_editDeviceFormatInformation_7.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 6 ] ); }

					if ( i == 7 ) { m_oSetupDialog.m_editDeviceFormatInformation_8.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 7 ] ); }
					
					m_oChannelWindows_LIVE[ i ].ShowWindow( TRUE );

					m_oChannelWindows_BK[ i ].ShowWindow( FALSE );			
				}	
			}
		}
	}

	CDialog::OnTimer(nIDEvent);
}

void sc580Dlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnLButtonDown(nFlags, point);	
	
	PostMessage( WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM( point.x, point.y ) );
}

BOOL sc580Dlg::OnButtonFileRecording_FileRecordDialog()
{
	CFileRecordDialog dlg;

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return true;
}

BOOL sc580Dlg::OnButtonShareRecording_FileRecordDialog()
{
	CShareRecordDialog dlg;

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return true;
}
